<?php
$post_type          = $settings->post_type;
$filter_tax         = $settings->filter_taxonomy;
$filter_field       = 'tax_' . $post_type . '_' . $filter_tax;
$filter_value       = isset( $settings->{$filter_field} ) ? $settings->{$filter_field} : false;
$filter_matching    = $filter_value ? $settings->{$filter_field . '_matching'} : false;
$filter_terms       = array();
$default_filter		= isset( $settings->filter_term_default ) ? $settings->filter_term_default : '';
$taxonomy           = get_taxonomy( $filter_tax );
$filter_all_label   = (isset($settings->filter_all_label) && ! empty($settings->filter_all_label)) ? $settings->filter_all_label : esc_html__( 'All', 'woopack' );

$terms_to_show		= isset( $settings->filter_terms ) ? $settings->filter_terms : '';
$terms_to_show_archive		= isset( $settings->filter_archive_terms ) ? $settings->filter_archive_terms : '';
$terms_children_on_archive 	= ( is_tax( $filter_tax ) || is_category() ) && ! empty( $terms_to_show_archive );

if ( $terms_children_on_archive ) {
	$terms_to_show = $terms_to_show_archive;
}

$order_by          = isset( $settings->filter_order_by ) ? $settings->filter_order_by : 'name';
$order             = isset( $settings->filter_order ) ? $settings->filter_order : 'ASC';
$order_by_meta_key = isset( $settings->filter_order_by_meta_key ) ? $settings->filter_order_by_meta_key : '';

$filter_args = array(
	'taxonomy' => $filter_tax,
	'orderby'  => $order_by,
	'order'    => $order,
);

if ( 'meta_value' === $order_by || 'meta_value_num' === $order_by ) {
	$filter_args['meta_key'] = $order_by_meta_key;
}

$rendered_products_terms = array();


if ( apply_filters( 'woopack_product_filters_show_related_terms', false, $settings ) ) {
	$sub_query = clone $query;

	if ( method_exists( 'WC_Query', 'pre_get_posts' ) ) {
		WC()->query->pre_get_posts( $sub_query );

		if ( isset( $sub_query->query_vars['wc_query'] ) ) {
			unset( $sub_query->query_vars['wc_query'] );
		}
	}

	$sub_query->set( 'numberposts', '-1' );
	$sub_query->set( 'posts_per_page', '-1' );
	$sub_query->set( 'nopaging', true );

	$rendered_products = $sub_query->query( $sub_query->query_vars );

	foreach ( $rendered_products as $single ) {
		$product_terms = wp_get_object_terms( $single->ID, $filter_tax, array( 'fields' => 'ids' ) );
		if ( ! is_wp_error( $product_terms ) ) {
			foreach ( $product_terms as $product_term ) {
				$rendered_products_terms[] = $product_term;
			}
		}
	}

	$rendered_products_terms = array_unique( $rendered_products_terms );

	if ( ! empty( $rendered_products_terms ) ) {
		$new_terms = array();

		foreach ( $terms as $term ) {
			if ( in_array( $term->term_id, $rendered_products_terms ) ) {
				$new_terms[] = $term;
			}
		}

		$terms = $new_terms;
	} else {
		$terms = array();
	}

	unset( $sub_query );
	unset( $rendered_products );
}


if ( $filter_value ) {
    $filter_term_ids = explode( ",", $filter_value );
    if ( ! $filter_matching ) {
        $filter_terms = get_terms( $filter_tax, array( 'exclude' => $filter_term_ids ) );
    } else {
        foreach ( $filter_term_ids as $filter_term_id ) {
			$filter_terms[] = get_term_by( 'id', $filter_term_id, $filter_tax );
		}
    }
}

if ( 'main_query' === $settings->data_source && $terms_children_on_archive ) {
	$current_term = get_queried_object();
	$current_children = get_term_children( $current_term->term_id, $current_term->taxonomy );
	if ( count( $current_children ) === 0 ) {
		return;
	}
	$terms = array( $current_term );
} else {
	$terms = ( count( $filter_terms ) > 0 ) ? $filter_terms : get_terms( $filter_args );
}

$count = is_array( $terms ) ? count( $terms ) : 0;

?>

<?php do_action( 'woopack_before_products_grid_filters_wrap' ); ?>

<div class="woopack-product-filters-wrap">
    <div class="woopack-product-filters-toggle">
        <span class="toggle-text"><?php echo $filter_all_label; ?></span>
    </div>
    <ul class="woopack-product-filters">
		<?php if ( empty( $default_filter ) ) { ?>
        <li class="woopack-product-filter woopack-filter-active" data-filter="*" tabindex="0"><?php echo $filter_all_label; ?></li>
		<?php } else { ?>
		<li class="woopack-product-filter" data-filter="*" tabindex="0"><?php echo $filter_all_label; ?></li>
		<?php } ?>

        <?php
        if ( $count > 0 ) {
			$terms = apply_filters( 'woopack_grid_filter_terms', $terms, $settings );
			$filtered_terms = array();
			foreach ( $terms as $term ) {
				if ( ! empty( $terms_to_show ) ) {
					if ( 'parent' === $terms_to_show ) {
						if ( $term->parent ) {
							$filtered_terms[] = $term->parent;
							continue;
						} else {
							$filtered_terms[] = $term->term_id;
						}
					} elseif ( 'children' === $terms_to_show ) {
						if ( ! $term->parent ) {
							$child_terms_args = array_merge( $filter_args, array( 'taxonomy' => $term->taxonomy, 'hide_empty' => false, 'child_of' => $term->term_id, 'fields' => 'ids' ) );
							$current_term_children = get_terms( $child_terms_args );
							$filtered_terms = array_merge( $filtered_terms, $current_term_children );
							continue;	
						} else {
							$term_children = get_term_children( $term->term_id, $term->taxonomy );
							if ( is_array( $term_children ) && count( $term_children ) > 0 ) {
								$filtered_terms = array_merge( $filtered_terms, $term_children );
							} else {
								$filtered_terms[] = $term->term_id;
							}
						}
					}
				} else {
					$filtered_terms[] = $term->term_id;
				}
			}
			if ( ! is_wp_error( $filtered_terms ) && count( $filtered_terms ) ) {
				$filtered_terms = array_unique( $filtered_terms );
				$filtered_terms = apply_filters( 'woopack_products_grid_filtered_terms', $filtered_terms, $terms, $settings );
				foreach ( $filtered_terms as $term_id ) {
					$term = apply_filters( 'woopack_products_grid_filtered_term', get_term( $term_id ), $filtered_terms, $settings );
					if ( empty( $term ) || 0 == $term->count ) {
						continue;
					}
					// Do not show terms which are not assigned to any products on the page.
					if ( ! empty( $rendered_products_terms ) && ! in_array( $term->term_id, $rendered_products_terms ) ) {
						continue;
					}

					$slug  = $term->slug;
					$slug  = urldecode( $slug ); // Support for non-English letters.
					$label = $term->name;

					$filter_class = 'woopack-product-filter';
					if ( $slug === $default_filter ) {
						$filter_class .= ' woopack-filter-active';
					}

					echo sprintf(
						'<li class="%s" data-filter="%s" data-term="%s" data-item-count="%s" tabindex="0" aria-label="%s">%s</li>',
						$filter_class,
						$taxonomy->name . '-' . $slug,
						$slug,
						$term->count,
						strip_tags( $label ),
						apply_filters( 'woopack_products_grid_filter_label', $label, $term, $settings )
					);
				}
			}
		}
        ?>
    </ul>
</div>

<?php do_action( 'woopack_after_products_grid_filters_wrap' ); ?>
